/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformRenderKey;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformRenderState;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_12137;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ItemTransformElementRenderer
extends class_11239<ItemTransformRenderState> {
    private static final Map<ItemTransformRenderKey, GpuTexture> TEXTURES = new IdentityHashMap<ItemTransformRenderKey, GpuTexture>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public ItemTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(ItemTransformRenderKey key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(ItemTransformRenderState item, class_11246 state, int windowScaleFactor) {
        boolean draw;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = 0.0f;
        ItemTransformRenderKey key = item.key();
        GpuTexture texture = TEXTURES.get(key);
        if (texture == null || key.dirty) {
            size = key.size * (float)windowScaleFactor;
            if (key.dirty) {
                key.dirty = false;
                if (texture != null && (float)texture.width() != size) {
                    texture.close();
                    texture = null;
                }
            }
            if (texture == null) {
                texture = GpuTexture.create((int)size);
                TEXTURES.put(key, texture);
            }
            draw = true;
        } else {
            draw = key.state.method_70948();
        }
        if (draw) {
            if (size == 0.0f) {
                size = key.size * (float)windowScaleFactor;
            }
            texture.prepare(this.field_60042);
            this.matrices.method_22903();
            this.matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
            if (key.padding != 0) {
                size -= (float)(key.padding * windowScaleFactor);
            }
            this.matrices.method_22905(size, -size, size);
            if (key.zRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(key.zRot));
            }
            if (key.xRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(key.xRot));
            }
            if (key.yRot != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(key.yRot));
            }
            boolean blockLight = key.state.method_65608();
            class_308 lighting = class_310.method_1551().field_1773.method_71114();
            if (blockLight) {
                lighting.method_71034(class_308.class_11274.field_60027);
            } else {
                lighting.method_71034(class_308.class_11274.field_60026);
            }
            class_11684 renderDispatcher = class_310.method_1551().field_1773.method_72911();
            class_11661 queue = renderDispatcher.method_73003();
            key.state.method_65604(this.matrices, (class_11659)queue, 0xF000F0, class_4608.field_21444, 0);
            renderDispatcher.method_73002();
            this.field_59933.method_22993();
            this.matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), item.method_72127(), item.comp_4122(), item.comp_4123(), item.comp_4124(), item.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, item.comp_4128(), null));
    }

    protected void renderToTexture(ItemTransformRenderState item, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Item Transform";
    }

    public Class<ItemTransformRenderState> method_70903() {
        return ItemTransformRenderState.class;
    }
}

